# -*- coding: utf-8 -*-
# License: GPL v.3 https://www.gnu.org/copyleft/gpl.html
import sys
from urllib import urlencode
from urlparse import parse_qsl
import xbmcgui
import xbmcplugin
_url = sys.argv[0]
_handle = int(sys.argv[1])

VIDEOS = {'Channels': [{'name': 'Hit List',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-002/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Max',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-050/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Brits+ Hits',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-154/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Party Favorites',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-033/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Love Songs',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-049/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Y2K',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-048/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': '90s',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-039/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': '80s',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-038/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': '70s',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-036/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Solid Gold Oldies',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-004/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Throwback Jamz',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-042/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'ALT RnB',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-163/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'RnB Soul',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-010/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'RnB Classics',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-043/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Hip-Hop and RnB',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-005/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Underground Hip-Hop',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-149/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Hip-Hop Classics',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-019/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Rap',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-011/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Rap 2K',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-165/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Reggae',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-024/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'New Wave',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-166/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Rock Hits',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-035/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Rock',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-044/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Classic Rock',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-006/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Soft Rock',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-001/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Alternative',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-014/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Adult Alternative',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-022/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Classic Alternative',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-146/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Metal',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-015/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Classic Metal',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-153/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Emo X Screamo',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-164/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Punk',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-152/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Indie',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-117/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Folk',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-156/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Blue Grass',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-148/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Funk',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-161/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Blues',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-046/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Jazz',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-012/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Smooth Jazz',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-007/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Teen Beats',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-051/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Pop Hits',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-029/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Pop and Country',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-047/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Todays Country',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-003/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Country Hits',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-040/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Classic Country',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-027/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Americana',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-147/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Dance/EDM',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-013/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Lounge',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-150/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Opera',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-167/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Easy Listening',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-009/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Classical Masterpieces',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-017/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Light Classical',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-008/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Soundscapes',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-045/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'Sounds of the Seasons',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-032/chunklist.m3u8',
                       'genre': 'MusicChoice'},
                      {'name': 'All Xmas',
                       'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                       'video': 'http://edge.music-choice-ac-chaina1.top.comcast.net/AudioChannels/Ch-158/chunklist.m3u8',
                       'genre': 'MusicChoice'}
                      ],
            'MusicChoiceVideo': [{'name': 'MusicChoiceVideo - Hits',
                      'thumb': 'https://github.com/jewbmx/repo/blob/master/img/logo-retina.png?raw=true',
                      'video': 'http://edge.music-choice-play-chaina1.top.comcast.net/PlayMetadataInserter/play/chunklist.m3u8',
                      'genre': 'MusicChoiceVideo'}
                     ]}


def get_url(**kwargs):
    return '{0}?{1}'.format(_url, urlencode(kwargs))

def get_categories():
    return VIDEOS.iterkeys()

def get_videos(category):
    return VIDEOS[category]

def list_categories():
    xbmcplugin.setPluginCategory(_handle, 'My Video Collection')
    xbmcplugin.setContent(_handle, 'videos')
    categories = get_categories()
    for category in categories:
        list_item = xbmcgui.ListItem(label=category)
        list_item.setArt({'thumb': VIDEOS[category][0]['thumb'],
                          'icon': VIDEOS[category][0]['thumb']})
        list_item.setInfo('video', {'title': category,
                                    'genre': category,
                                    'mediatype': 'video'})
        url = get_url(action='listing', category=category)
        is_folder = True
        xbmcplugin.addDirectoryItem(_handle, url, list_item, is_folder)
    xbmcplugin.endOfDirectory(_handle)

def list_videos(category):
    xbmcplugin.setPluginCategory(_handle, category)
    xbmcplugin.setContent(_handle, 'videos')
    videos = get_videos(category)
    for video in videos:
        list_item = xbmcgui.ListItem(label=video['name'])
        list_item.setInfo('video', {'title': video['name'],
                                    'genre': video['genre'],
                                    'mediatype': 'video'}) 
        list_item.setArt({'thumb': video['thumb'], 'icon': video['thumb']})
        list_item.setProperty('IsPlayable', 'true')
        url = get_url(action='play', video=video['video'])
        is_folder = False
        xbmcplugin.addDirectoryItem(_handle, url, list_item, is_folder)
    xbmcplugin.endOfDirectory(_handle)

def play_video(path):
    play_item = xbmcgui.ListItem(path=path)
    xbmcplugin.setResolvedUrl(_handle, True, listitem=play_item)

def router(paramstring):
    params = dict(parse_qsl(paramstring))
    if params:
        if params['action'] == 'listing':
            list_videos(params['category'])
        elif params['action'] == 'play':
            play_video(params['video'])
        else:
            raise ValueError('Invalid paramstring: {0}!'.format(paramstring))
    else:
        list_categories()

if __name__ == '__main__':
    router(sys.argv[2][1:])
